/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH last_success_duration AS (
    SELECT DISTINCT ON (step_id)
        jsljstid  AS step_id,
        jslduration AS last_success_duration
    FROM pgagent.pga_jobsteplog
    WHERE jslstatus='s'
    ORDER BY jsljstid, jslstart DESC
)
SELECT DISTINCT ON (j.jobid)
    jobname AS job,
    jslstart AT TIME ZONE current_setting('TIMEZONE') AS "start time",
    jslduration AS duration,
    CASE WHEN jslstatus='s' THEN 'success'
         WHEN jslstatus='r' THEN 'running'
         WHEN jslstatus='f' THEN 'failed'
         WHEN jslstatus='i' THEN 'ignored failed'
         WHEN jslstatus='d' THEN 'aborted'
    END AS status,
    CASE WHEN jslstatus='f' THEN jsloutput /* jsloutput is valid only for 'failed' jslstatus */
        ELSE ''
    END AS output,
    jobenabled AS enabled,
    jobnextrun AT TIME ZONE current_setting('TIMEZONE') AS "next run time",
    lsd.last_success_duration
    FROM pgagent.pga_jobsteplog l
        JOIN pgagent.pga_jobstep s ON l.jsljstid=s.jstid
        JOIN pgagent.pga_job j ON s.jstjobid=j.jobid
        LEFT JOIN last_success_duration lsd ON s.jstid = lsd.step_id
    WHERE CASE WHEN {{only_enabled}} THEN jobenabled ELSE TRUE END
    ORDER BY j.jobid, jslstart DESC;
