/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT
    COALESCE(volume.display_name, last_time_generic_current.volume_name) AS "volume name",
    mtime_age AS "mtime age",
    atime_age AS "atime age",
    ROUND(SUM(size) / (1024 * 1024 * 1024.0), 2) AS "size logical (GiB)",
    ROUND(SUM(physical_size) / (1024 * 1024 * 1024.0), 2) AS "size physical (GiB)",
    SUM(count) AS count,
    SUM(cost) AS cost
FROM sf_reports.last_time_generic_current
    LEFT JOIN sf_volumes.volume ON last_time_generic_current.volume_name = volume.name
GROUP BY "volume name", mtime_age, atime_age
ORDER BY "volume name", atime_age
