/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH ordered_scans_with_prev_state AS (
    SELECT
        s.volume_id AS vol_id,
        s.name as scan_name,
        heartbeat,
        s.state_name as state,
        LAG(s.state_name) OVER (PARTITION BY s.volume_id ORDER BY s.heartbeat) as prev_state,
        s.reason as reason,
        s.reason_msg as reason_msg,
        ROW_NUMBER() OVER (PARTITION BY s.volume_id ORDER BY s.heartbeat DESC) as row_num
    FROM sf_scans.scan s
    ORDER BY row_num
),
streaks AS (
    SELECT *,
        SUM(CASE WHEN (state <> prev_state AND prev_state IS NOT NULL) THEN 1 ELSE 0 END)
            OVER (PARTITION BY vol_id ORDER BY row_num DESC) AS streak_id
    FROM ordered_scans_with_prev_state
    WHERE row_num <= 100
),
streak_lens AS (
    SELECT *,
        COUNT(*) OVER (PARTITION BY vol_id, streak_id) AS streak_len
    FROM streaks
),
volumes_with_fails_as_last_scan AS (
    SELECT
        v.name AS "volume name",
        scan_name,
        heartbeat,
        state AS "scan status",
        reason,
        reason_msg,
        streak_len,
        MAX(streak_len) FILTER (WHERE row_num=1 AND state='fail') OVER() AS max_fail_streak_len
    FROM streak_lens sl JOIN sf_volumes.volume v ON sl.vol_id=v.id
    WHERE row_num <= 10 AND (vol_id IN (SELECT vol_id FROM streak_lens WHERE row_num=1 AND state='fail'))
    ORDER BY v.name, row_num
)
SELECT *
FROM volumes_with_fails_as_last_scan
UNION ALL
SELECT NULL AS "volume name",
        NULL AS scan_name,
        NULL AS heartbeat,
        NULL AS "scan status",
        NULL AS reason,
        NULL AS reason_msg,
        0 AS streak_len,
        0 AS max_fail_streak_len
WHERE NOT EXISTS (SELECT 1 FROM volumes_with_fails_as_last_scan)
