/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH all_tables AS (
    SELECT CONCAT(tables.schemaname, '.', tables.relname) AS "tables with dead tuples",
           tables.n_live_tup::BIGINT AS "live tuples",
           tables.n_dead_tup::BIGINT AS "dead tuples",
           CASE WHEN tables.n_live_tup > 0 THEN ROUND((tables.n_dead_tup / tables.n_live_tup::NUMERIC), 2)
           ELSE NULL END AS "ratio of dead/live tuples",
           pg_class.reltuples::BIGINT,
           pg_class.relpages,
           tables.last_vacuum,
           tables.last_autovacuum
    FROM pg_stat_all_tables tables
    LEFT JOIN pg_class ON pg_class.oid = tables.relid
    WHERE tables.schemaname LIKE 'sf%'
)
SELECT *
    FROM all_tables
    WHERE "dead tuples" > 0
UNION ALL
SELECT 'sf.*',
       COALESCE(SUM("live tuples")::BIGINT, 0),
       COALESCE(SUM("dead tuples")::BIGINT, 0),
       CASE WHEN SUM("live tuples") > 0 THEN ROUND((SUM("dead tuples") / SUM("live tuples")::NUMERIC), 2)
       ELSE NULL END AS "ratio of dead/live tuples",
       SUM(reltuples)::BIGINT,
       SUM(relpages),
       NULL,
       NULL
FROM all_tables
ORDER BY "dead tuples" DESC, "tables with dead tuples";
