/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    parent_table AS "table",
    ROUND(SUM(n_live_tup) / 1000.0 / 1000, 2) AS "live tuples",
    ROUND(SUM(n_dead_tup) / 1000.0 / 1000, 2) AS "dead tuples",
    run_time
FROM sf_reports.postgres_table_size_history
WHERE parent_table ~ '^(file_(current|history)|dir_(current|history)|job_result_(current|history))$'
AND run_time > NOW() - INTERVAL '730 days'
GROUP BY run_time, parent_table
ORDER BY run_time, parent_table
