/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT tablespace.spcname AS tablespace,
       pguser.usename AS owner,
       CASE WHEN PG_TABLESPACE_LOCATION(tablespace.oid) != '' THEN PG_TABLESPACE_LOCATION(tablespace.oid)
       ELSE 'default' END AS location
FROM pg_tablespace tablespace
LEFT JOIN pg_user pguser ON pguser.usesysid = tablespace.spcowner
ORDER BY spcname;
