/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    sf.get_extension(name) AS ext,
    ROUND(SUM(size) / (1024::NUMERIC * 1024 * 1024 * 1024), 2) AS "logical size (TiB)",
    ROUND(SUM(blocks) * 512 / (1024::NUMERIC * 1024 * 1024 * 1024), 2) AS "physical size (TiB)",
    COUNT(*) AS count
FROM sf.file_current
WHERE ('{{volume}}' = '*' OR volume_id = (SELECT id FROM sf_volumes.volume WHERE name = '{{volume}}'))
  AND size >= {{min_file_size_gib}} * 1024::BIGINT * 1024 * 1024
  -- 4 is a reasonable approximation.
  -- Could have been 2 or 3, but 4 vastly increases the chance that it is actually sparse (vs. compressed)
  AND size > 4 * blocks * 512
GROUP BY ext
ORDER BY ext
