/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    v.name AS volume,
    -- regexp_replace is used to add a separator ('/') but only if d.name != ''
    -- to not add '/' at the beginning
    CONCAT(REGEXP_REPLACE(d.name, '([^/])$', '\1/'), f.name) AS path,
    -- one size is in GiB and other in MiB because the physical size is expected to be dramatically smaller than the logical
    ROUND(f.size / (1024::NUMERIC * 1024 * 1024), 2) AS "logical size (GiB)",
    ROUND(f.blocks * 512 / (1024::NUMERIC * 1024), 2)  AS "physical size (MiB)"
FROM sf.file_current f
INNER JOIN sf.dir_current d ON f.volume_id = d.volume_id AND f.parent_id = d.id
INNER JOIN sf_volumes.volume v ON v.id = d.volume_id
WHERE ('{{volume}}' = '*' OR f.volume_id = (SELECT id FROM sf_volumes.volume WHERE name = '{{volume}}'))
  AND f.size >= {{min_file_size_gib}} * 1024::BIGINT * 1024 * 1024
  -- 4 is a reasonable approximation.
  -- Could have been 2 or 3, but 4 vastly increases the chance that it is actually sparse (vs. compressed)
  AND f.size > 4 * f.blocks * 512
ORDER BY volume, path
