/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH gid_info AS (
  SELECT gid,
         CASE WHEN name IS NULL OR name = '' THEN gid::VARCHAR
         ELSE name END AS name,
         COUNT(DISTINCT volume_id) AS volumes_count
  FROM sf.gid_mapping
  GROUP BY gid,
           name
),
gid_uid_info AS (
  SELECT gid,
         COUNT(DISTINCT UID) AS users_count
  FROM sf.gid_to_uid_mapping
  GROUP BY gid
),
group_size_files_count AS (
  SELECT gid,
         ROUND(SUM(size)/1024/1024/1024, 2) AS size_gib,
         SUM(count)::BIGINT AS files
  FROM sf_reports.last_time_generic_current
  GROUP BY gid
)

SELECT gid_info.name AS "group name",
     '<a href="DASHBOARD_LINK(group-detail-analytics)?p_groupname=' || name || '">' || 'Details' || '</a>' AS "Details dashboard",
     volumes_count AS "volumes count",
     CASE WHEN users_count IS NOT NULL THEN users_count
     ELSE NULL
     END AS "users count",
     CASE WHEN size_gib IS NOT NULL THEN size_gib
     ELSE NULL
     END AS "size GiB",
     CASE WHEN files IS NOT NULL THEN files
     ELSE NULL
     END AS "files"
FROM gid_info
LEFT JOIN gid_uid_info ON gid_uid_info.gid = gid_info.gid
LEFT JOIN group_size_files_count ON group_size_files_count.gid = gid_info.gid
