/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH users AS (
    SELECT DISTINCT
        gidm.name AS group_name,
        gidm.gid AS gid,
        vol.default_agent_address AS agent_address,
        uidm.name AS name,
        uidm.uid AS uid
    FROM sf.uid_mapping uidm
    LEFT JOIN sf.gid_to_uid_mapping gtum ON uidm.uid = gtum.uid AND uidm.volume_id = gtum.volume_id
    LEFT JOIN sf.gid_mapping gidm ON gtum.gid = gidm.gid AND gtum.volume_id = gidm.volume_id
    LEFT JOIN sf_volumes.volume vol ON vol.id = gidm.volume_id
    WHERE gidm.name = '{{groupname}}'
    GROUP BY gidm.name, gidm.gid, vol.default_agent_address, uidm.uid, uidm.name
    ORDER BY gidm.name, gidm.gid, vol.default_agent_address, uidm.uid, uidm.name
),
users_count AS (
    SELECT
        group_name,
        gid,
        agent_address,
        COUNT(*) AS users
    FROM users
    GROUP BY group_name, gid, agent_address
),
group_rows AS (
    SELECT
        gidm.name AS name,
        gidm.gid AS gid,
        vol.default_agent_address AS agent_address,
        COUNT(DISTINCT vol.id) AS "number of volumes",
        users.users AS "number of users",
        ROUND(SUM(ltgc.size) / (1024.0 * 1024 * 1024), 2) AS "size GiB",
        SUM(ltgc.count)::BIGINT AS "files count"
    FROM sf.gid_mapping gidm
    LEFT JOIN sf_volumes.volume vol ON vol.id = gidm.volume_id
    LEFT JOIN sf_reports.last_time_generic_current ltgc ON ltgc.volume_name = vol.name
                                                       AND ltgc.group_name = gidm.name
    LEFT JOIN users_count users ON users.group_name = gidm.name
                               AND users.gid = gidm.gid
                               AND users.agent_address = vol.default_agent_address
    WHERE gidm.name = '{{groupname}}'
    GROUP BY gidm.gid, gidm.name, vol.default_agent_address, users.users
    ORDER BY gidm.name, gidm.gid, agent_address
)

SELECT * FROM group_rows
UNION ALL
SELECT
    'ALL {{groupname}}',
    NULL,
    NULL,
    SUM("number of volumes")::BIGINT,
    SUM("number of users")::BIGINT,
    SUM("size GiB"),
    SUM("files count")::BIGINT
FROM group_rows
HAVING COUNT(*) > 1
