/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

/*
INSTRUCTION to ADD/REMOVE common extensions
Extensions are configured in "section" most_common_ext
The first extension is configured by "SELECT '[EXTENSION]' AS ext, '[TYPE]' AS ext_type";
Any other is added by "UNION ALL SELECT '[EXTENSION]', '[TYPE]'";
Extension can be removed by deleting the line;

[EXTENSION] - extension to add, for example txt/tmp
[TYPE] - type of extension, for example TEXT/IMAGE
*/

WITH most_common_ext AS (
    SELECT 'doc' AS ext, 'TEXT' AS ext_type
    UNION ALL SELECT 'docx', 'TEXT'
    UNION ALL SELECT 'odt', 'TEXT'
    UNION ALL SELECT 'pdf', 'TEXT'
    UNION ALL SELECT 'tex', 'TEXT'
    UNION ALL SELECT 'txt', 'TEXT'
    UNION ALL SELECT 'wpd', 'TEXT'
    UNION ALL SELECT 'ods', 'SPREADSHEET'
    UNION ALL SELECT 'xls', 'SPREADSHEET'
    UNION ALL SELECT 'xlsm', 'SPREADSHEET'
    UNION ALL SELECT 'xlsx', 'SPREADSHEET'
    UNION ALL SELECT 'key', 'PRESENTATION'
    UNION ALL SELECT 'odp', 'PRESENTATION'
    UNION ALL SELECT 'pps', 'PRESENTATION'
    UNION ALL SELECT 'ppt', 'PRESENTATION'
    UNION ALL SELECT 'pptx', 'PRESENTATION'
    UNION ALL SELECT 'asp', 'WEB'
    UNION ALL SELECT 'aspx', 'WEB'
    UNION ALL SELECT 'css', 'WEB'
    UNION ALL SELECT 'htm', 'WEB'
    UNION ALL SELECT 'html', 'WEB'
    UNION ALL SELECT 'js', 'WEB'
    UNION ALL SELECT 'php', 'WEB'
    UNION ALL SELECT 'xhtml', 'WEB'
    UNION ALL SELECT 'asm', 'PROGRAMMING'
    UNION ALL SELECT 'bash', 'PROGRAMMING'
    UNION ALL SELECT 'c', 'PROGRAMMING'
    UNION ALL SELECT 'cc', 'PROGRAMMING'
    UNION ALL SELECT 'cpp', 'PROGRAMMING'
    UNION ALL SELECT 'cs', 'PROGRAMMING'
    UNION ALL SELECT 'go', 'PROGRAMMING'
    UNION ALL SELECT 'java', 'PROGRAMMING'
    UNION ALL SELECT 'pl', 'PROGRAMMING'
    UNION ALL SELECT 'py', 'PROGRAMMING'
    UNION ALL SELECT 'rb', 'PROGRAMMING'
    UNION ALL SELECT 'sh', 'PROGRAMMING'
    UNION ALL SELECT 'csv', 'DATA'
    UNION ALL SELECT 'db', 'DATA'
    UNION ALL SELECT 'log', 'DATA'
    UNION ALL SELECT 'sav', 'DATA'
    UNION ALL SELECT 'xml', 'DATA'
    UNION ALL SELECT '7z', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'bz2', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'bzip2', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'gz', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'gzip', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'lzma', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'rar', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'tar', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'zip', 'ARCHIVE/COMPRESSION'
    UNION ALL SELECT 'bmp', 'IMAGE'
    UNION ALL SELECT 'jpeg', 'IMAGE'
    UNION ALL SELECT 'jpg', 'IMAGE'
    UNION ALL SELECT 'png', 'IMAGE'
    UNION ALL SELECT 'svg', 'IMAGE'
    UNION ALL SELECT 'avi', 'VIDEO'
    UNION ALL SELECT 'mkv', 'VIDEO'
    UNION ALL SELECT 'mp4', 'VIDEO'
    UNION ALL SELECT 'mpeg', 'VIDEO'
    UNION ALL SELECT 'mpg', 'VIDEO'
    UNION ALL SELECT 'wmv', 'VIDEO'
    UNION ALL SELECT 'mp3', 'AUDIO'
    UNION ALL SELECT 'wav', 'AUDIO'
    UNION ALL SELECT 'wma', 'AUDIO'
    UNION ALL SELECT 'exe', 'MISCELLANEOUS'
    UNION ALL SELECT 'ini', 'MISCELLANEOUS'
    UNION ALL SELECT 'jar', 'MISCELLANEOUS'
    UNION ALL SELECT 'tmp', 'MISCELLANEOUS'
),
extensions AS
( SELECT ext,
       ROUND(SUM(size_volume_ext)/(1024::BIGINT*1024), 2) AS ext_size,
       SUM(count_volume_ext)::BIGINT AS ext_count
  FROM sf_reports.extensions_current
  WHERE volume_name LIKE '{{volume}}'
  GROUP BY ext )

SELECT defined_ext.ext_type AS "Ext type",
   ext.ext AS "Ext",
   ext_size AS "Size MiB",
   ext_count AS "Count"
FROM extensions ext
JOIN most_common_ext defined_ext ON defined_ext.ext = ext.ext
