/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH extensions AS
( SELECT ext,
        CASE
            WHEN ext ~ '^[-_]' THEN ext
            ELSE REGEXP_REPLACE(ext, '[-_].*$', '')
        END AS "ext_part",
        size_volume_ext,
        count_volume_ext
  FROM sf_reports.extensions_current
  WHERE volume_name LIKE '{{volume}}' ),
STATISTICS AS
( SELECT ext_part AS "extension",
        COUNT(DISTINCT ext) AS "count different full extensions",
        SUM(count_volume_ext)::BIGINT AS "total count",
        ROUND(SUM(size_volume_ext)/(1024::BIGINT*1024*1024*1024), 2) AS "total size TiB",
        CASE
            WHEN COUNT(DISTINCT ext) > 1 THEN CONCAT('<a href=queries/QUERY_ID_FOR_REPORT(grouped_extension_prefixes_details)?p_volume={{volume}}&p_extension=', ext_part, '>ALL</a>')
            ELSE ''
        END AS "SEE all sub extensions",
        CASE
            WHEN COUNT(DISTINCT ext) > 1 THEN CONCAT('<a href=queries/QUERY_ID_FOR_REPORT(grouped_extension_prefixes_statistics)?p_extension=', ext_part, '&p_volume={{volume}}>Statistics</a>')
            ELSE ''
        END AS "sub extension statistics"
  FROM extensions
  GROUP BY ext_part)

SELECT *
FROM STATISTICS
WHERE "count different full extensions" >= {{min_distinct_full_ext}}
ORDER BY "extension" ASC,
        "total size TiB" DESC
