/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */


WITH ajobs AS (
    SELECT
        target_id,
        EXTRACT(EPOCH FROM (end_time - creation_time)) AS time,
        JSONB_ARRAY_ELEMENTS_TEXT(low_level_jobs::JSONB->'UPLOADING_FILES')::BIGINT AS llj
    FROM sf_archive.archive_job
    WHERE creation_time >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
),
jobs AS (
    SELECT
        at.type AS target_type,
        (sji.fs_stats->>'fs_bytes_done')::BIGINT AS Bytes,
        CASE WHEN ajobs.time != 0
            THEN (sji.fs_stats->>'fs_bytes_done')::BIGINT / (1000 * 1000.0) / ajobs.time
        ELSE 0.00
        END AS "MB/s"
    FROM ajobs
    INNER JOIN sf_dispatcher.incarnation sji ON ajobs.llj = sji.job_id
    INNER JOIN sf_archive.archive_target at ON ajobs.target_id = at.id
)

SELECT
    target_type AS "target type",
    COUNT(*) AS "how many jobs",
    ROUND(SUM(Bytes) / (1000 * 1000 * 1000.0), 2) AS "archived data size GB",
    ROUND(AVG("MB/s")::NUMERIC, 2) AS "avg MB/s",
    ROUND(MAX("MB/s")::NUMERIC, 2) AS "max MB/s",
    ROUND((PERCENTILE_CONT(0.5) WITHIN GROUP(ORDER BY "MB/s"))::NUMERIC, 2) AS "median MB/s"
    -- MIN() was skipped because there are too many zeros in customer databases
FROM jobs
GROUP BY target_type
UNION ALL
SELECT 'ALL', 0, 0.00, 0.00, 0.00, 0.00
FROM jobs
HAVING COUNT(*) = 0
ORDER BY "target type"
