/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT v.name as "source vol",
       to_char(date_trunc('month', created_at), 'YYYY-MM') as month,
       sum((fs_stats->>'fs_entries_done')::BIGINT) AS entries,
       sum((fs_stats->>'fs_bytes_done')::BIGINT) / (1024::BIGINT * 1024 * 1024) as size_gib
FROM sf_dispatcher.incarnation i
INNER JOIN sf_dispatcher.job j ON j.id = i.job_id
INNER JOIN sf_volumes.volume v ON v.id = j.volume_id
WHERE (fs_stats->>'fs_entries_done')::BIGINT > 0
      and i.created_at > now() - interval '1 year'
GROUP BY v.name, month
ORDER BY entries DESC;
