/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH raw_result AS (
    select
        volume_id,
        zone_tag_name_id,
        tag_name_id,
        atime_age,
        mtime_age as mtime_age,
        SUM(logical_size) AS logical_size,
        SUM(physical_size) AS physical_size,
        SUM(count) AS count
    FROM tags_report_plpython('zone_namespace_tags')
    GROUP BY volume_id, zone_tag_name_id, tag_name_id, atime_age, mtime_age
)
SELECT v.name AS volume_name,
       z.name AS zone,
       tns.name AS namespace,
       tn.name AS tag,
       raw.atime_age,
       raw.mtime_age,
       raw.logical_size AS size,  -- name size is backward compatibility
       raw.physical_size,
       CASE
            WHEN COALESCE(v.total_capacity, 0) > 0 THEN ROUND(raw.physical_size * 100 / v.total_capacity, 1)
            ELSE NULL
       END AS "%_of_whole_volume",
       raw.count::BIGINT,
       raw.physical_size / (1000 * 1000 * 1000) * CAST(COALESCE(vupc.value, '0') AS FLOAT) AS cost
FROM raw_result AS raw
    INNER JOIN sf.tag_name zn ON raw.zone_tag_name_id = zn.id
    INNER JOIN sf_auth.zone AS z ON zn.name = z.id::VARCHAR
    INNER JOIN sf.tag_name tn ON raw.tag_name_id = tn.id
    INNER JOIN sf.tag_namespace AS tns ON tn.namespace_id = tns.id
    LEFT JOIN sf_volumes.volume AS v ON raw.volume_id = v.id
    LEFT JOIN sf_volumes.user_param AS vupc ON vupc.volume_id = raw.volume_id AND vupc.name = 'cost_per_gb'
ORDER BY volume_name, zone, tag, atime_age, mtime_age;
