#!/bin/bash

########################################################
#
# SF simple to report to find orphaned files and directories where
# a uid or gid doesn't map to a name
#
########################################################

#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************
# Version 1.1 2023-10-18  Make orphans.sh explicitly connect to starfish db so it can be run by postgres user


set -euo pipefail

SFHOME=${SFHOME:-/opt/starfish}

function usage() {
    echo "find all uid/gid orphans where a mapping doesn't exist to a text name"
    echo "usage: $0 [-PHugh] <volume>"
    echo "   -H   turn off header row (uid, gid)"
    echo "   -P   turn off terminal pager"
    echo "   -u   uid only"
    echo "   -g   gid only"
    echo "   -h   this help"
    exit 1
}

header=1
uid_only=0
gid_only=0

while getopts "PHhug" opt; do
    case ${opt} in
       P)
          export PAGER=""
          ;;
       H)
          header=0
          ;;
       u)
          uid_only=1
          ;;
       g)
          gid_only=1
          ;;
       \?|h)
          usage
    esac
done

# Check if any arguments are provided
if [ $# -eq 0 ]; then
    usage
fi
shift $((OPTIND-1))

vol=$1

queryf=$(cat <<HERE1
SELECT 'f', v.name || ':' || d.path || '/' || f.name AS volpath, f.uid
    FROM sf.file_current f
        INNER JOIN sf.dir_current d
            ON f.parent_id = d.id AND f.volume_id = d.volume_id
        INNER JOIN sf_volumes.volume v
            ON v.id = d.volume_id
        LEFT JOIN sf.uid_mapping u
            ON f.uid = u.uid AND u.volume_id = v.id
    WHERE u.uid IS NULL AND v.name = '${vol}'

UNION ALL

SELECT 'd', v.name || ':' || d.path AS volpath, d.uid
    FROM sf.dir_current d
        INNER JOIN sf_volumes.volume v
            ON v.id = d.volume_id
        LEFT JOIN sf.uid_mapping u
            ON d.uid = u.uid AND d.volume_id = u.volume_id
    WHERE u.uid IS NULL AND v.name = '${vol}';
HERE1
)

queryg=$(cat <<HERE2
SELECT 'f', v.name || ':' || d.path || '/' || f.name AS volpath, f.gid
    FROM sf.file_current f
    INNER JOIN sf.dir_current d
        ON f.parent_id = d.id AND f.volume_id = d.volume_id
    INNER JOIN sf_volumes.volume v
        ON v.id = d.volume_id
    LEFT JOIN sf.gid_mapping u
        ON f.gid = u.gid AND u.volume_id = v.id
    WHERE u.gid IS NULL AND v.name = '${vol}'

UNION ALL

SELECT 'd', v.name || ':' || d.path as volpath, d.gid
    FROM sf.dir_current d
        INNER JOIN sf_volumes.volume v
            ON v.id = d.volume_id
        LEFT JOIN sf.gid_mapping g
            ON d.gid = g.gid AND d.volume_id = g.volume_id
    WHERE g.gid IS null AND v.name = '${vol}';
HERE2
)

db_arg=""
if [[ $(whoami) == "postgres" ]]; then
    db_arg="-d starfish"
fi

if [[ ${gid_only} != 1 ]]; then
    if [[ "${header}" -eq 1 ]]; then
        echo "uid missing"
    fi
    # shellcheck disable=SC2086
    "${SFHOME}/bin/tools/runquery" --tuples-only --no-align --field-separator=, --command="${queryf}" ${db_arg}
fi

if [[ ${uid_only} != 1 ]]; then
    if [[ $header -eq 1 ]]; then
        echo "gid missing"
    fi
    # shellcheck disable=SC2086
    "${SFHOME}/bin/tools/runquery" --tuples-only --no-align --field-separator=, --command="${queryg}" ${db_arg}
fi
