#!/bin/bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

SFHOME=${SFHOME:-/opt/starfish}
SF=${SFHOME}/bin/client
SFREMOVE=${SFHOME}/bin/remove
PROG="$0"

usage() {
    [[ $# -gt 1 ]] && echo "$1"
    cat <<EOF

${PROG} [options] <volume> [run-job options]

    -h, --help   - print this help and exit
    -m, --mtime  - use only file modification time (by default only access time is used)
    --days [int] - how old file must be to be removed (by default 365)
    --dry-run    - do not remove any file, only run job and store result
EOF
    exit 1
}

DRY_RUN=""
VERBOSE=""
MODIFIER="a"
DAYS_AGO="365"

while [[ $# -gt 0 ]]; do
    case $1 in
    "-h"|"--help")
        usage
        ;;
    "-m"|"--mtime")
        MODIFIER="m"
        shift
        ;;
    "--days")
        shift
        DAYS_AGO=$1
        shift
        ;;
    "--dry-run")
        DRY_RUN="--dry-run"
        shift
        ;;
    "--verbose")
        VERBOSE="--verbose"
        shift
        ;;
    *)
        break
        ;;
    esac;
done

[ "${DAYS_AGO}" -gt 0 ] || usage "--days must be greater then zero! (but is: ${DAYS_AGO})"

OLDER_THAN="$(date --date "${DAYS_AGO} days ago" +"%Y%m%d")"

${SF} job start "${SFREMOVE} ${DRY_RUN} ${VERBOSE} --${MODIFIER}time-older-than ${DAYS_AGO}" "$@" \
        --${MODIFIER}time "19000101-${OLDER_THAN}" --from-scratch --no-post-verification
