#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

# Example job command in powershell
# This command can be run using Starfish:
#
# sf job start --job-name basename 'powershell.exe -File "C:\\Program Files\\starfish\\bin\\examples\\job\\basename_command.ps1"' volume_name:srcdir --paths-via-stdin
#
# This job can be customised by changing implementation of Process-Path function


$splitstr = [char]0x0000
$stdout = [System.Console]::OpenStandardOutput()
[Console]::OutputEncoding = [System.Text.Encoding]::UTF8


# Helper function to write to stderr in powershell
# See: https://stackoverflow.com/a/15669365
function Write-StdErr {
    param ([PSObject] $InputObject)
    $outFunc = if ($Host.Name -eq 'ConsoleHost') {
        [Console]::Error.WriteLine
    } else {
        $host.ui.WriteErrorLine
    }
    if ($InputObject) {
        [void] $outFunc.Invoke($InputObject.ToString())
    } else {
        [string[]] $lines = @()
        $Input | ForEach-Object { $lines += $_.ToString() }
        [void] $outFunc.Invoke($lines -join "`r`n")
    }
}

# Helper function to write raw strings to stdout in powershell
function Write-Raw-StdOut {
    param ([String] $InputObject)
    $bytes = ([System.Text.Encoding]::UTF8.GetBytes($InputObject))
    $stdout.Write($bytes, 0, $bytes.Length)
}

# Powershell by default encodes standard input and standard output streams
# See: https://stackoverflow.com/a/38668360
# This line reverses this encoding and reencodes standard input stream into utf8
$data = $Input | ForEach-Object { [text.encoding]::UTF8.GetString([Console]::InputEncoding.GetBytes($_)) }



function Process-Path([string]$srcpath) {
    # You can write your code here.
    # $srcpath is path of file being processed by job
    # result of this function is a string and will be
    # saved in database
    #
    # This example takes basename from file path and
    # returns it as job result, as long $srcpath exists.

    $test = (Test-Path -Path $srcpath)
    Write-StdErr "Test of $srcpath result $test"
    if (! $test) {
        throw "Source file does not exist, skipping"
    }

    # Special case for job root directory, where $path ends with "\"
    # In Linux    basename \foo\ == ""
    # In Windows  Split-Path -Path \foo\ -Leaf == "foo"
    if ($srcpath.Substring($srcpath.Length - 1) -eq "\") {
        $basename = ""
    } else {
        $basename = ( Split-Path -Path $path -Leaf)
    }
    Write-StdErr "Basename $( $basename )"

    return $basename
}


Foreach ($path in $data.Split($splitstr)) {
    # Output format is:
    # [file path][\0][job result][\0]

    try
    {
        $job_result = Process-Path "$path"
    }
    catch
    {
        Write-StdErr "Error while processing ${path}: $($PSItem.ToString())"
        # Do not output any result for $path in case of an error.
        continue
    }

    # output [file path]
    Write-Raw-StdOut $path
    # output [\0]
    Write-Raw-StdOut $splitstr

    # output [job result]
    Write-Raw-StdOut $job_result
    # output [\0]
    Write-Raw-StdOut $splitstr
}
