#!/bin/bash

########################################################
#
# SF simple to inform about quarantined volumes because of failure in dispatchscan
#
########################################################

#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

MAILTO=""
TMPFILE="/var/tmp/disp_quarantined.txt"
DISPATCH_SCAN_LOG_PATH="/opt/starfish/log/dispatch_scan.log"

usage()
{
cat << EOF
$PROG $VERSION

Usage: $0 options
Options:
    --help/-h                        - Print this help and exit
    --email-to/-e EmailID            - Email ID to send the output to

Examples:

    ${PROG} --email-to abc@company.com
EOF
}


# If the first parameter is -h or --help, call usage routine

if [[ "$1" == "-h" || "$1" == "--help" ]];  then
    usage
    exit 0
fi

check_parameters_value() {
    local param="$1"
    [ $# -gt 1 ] || echo "Missing value for parameter ${param}"
}

parse_input_parameters() {
    while [[ "$#" -gt "0" ]];
    do
        case "$1" in
         "-e"|"--email-to")
         check_parameters_value "$@"
         shift
         MAILTO="$1"
        ;;
        *)
         echo "Invalid input parameter: $1. Usage below:"
         usage
         exit 1
        ;;

        esac
        shift
    done
}

parse_input_parameters "$@"
# Trigger logging of failed volumes in dispatchscan.py by sending USR1
pkill -USR1 dispatchscan.py
# could there be a race condition to check the log? maybe. deal with that
usleep 100000
# The "sed s/[^\ ]*]$//g" is to remove the " [filename:linenumber]" marker from the end of the dispatchscan log
tail -100 "${DISPATCH_SCAN_LOG_PATH}" | grep -E "The following volumes are marked as failed:" | tail -n 1 | \
awk -F"failed:" 'length($2) > 1 {print "The following volumes were quarantined because of failure in dispatchscan:"; print $2; print "\nPlease review /opt/starfish/log/dispatch_scan.log and when problems are fixed use \"pkill -HUP dispatchscan.py\" to clear volume failures."}' | sed s/[^\ ]*]$//g > "${TMPFILE}"


if [[ -n "${MAILTO}" && -s "${TMPFILE}" ]]; then
    mailx -s "Failed dispatchscan volumes" "${MAILTO}" < "${TMPFILE}"
fi

rm -f ${TMPFILE}
exit 0
