#!/opt/starfish/examples/venv/bin/python3
"""
***********************************************************************************************************

 Starfish Storage Corporation ("Starfish") CONFIDENTIAL
 Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.

 NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
 Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
 intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
 U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
 Dissemination of this information or reproduction of this material is strictly forbidden unless prior
 written permission is obtained from Starfish. Access to the source code contained herein is hereby
 forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
 confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
 Starfish's software.

 ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
 THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
 AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
 FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
 DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
 WHOLE OR IN PART.

 FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
   These notices shall be marked on any reproduction of this data, in whole or in part.
   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
   Software clause at DFARS 52.227-7013.

***********************************************************************************************************

By Doug Hughes
some api examples
"""
import argparse
import json
import sys

import requests
import urllib3

# This is here to pass jenkins tests
if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--passwd", required=True)
    parser.add_argument("--user")
    parser.add_argument("--server-addr", required=True, help="starfish server name or IP")
    parser.add_argument("--volume", required=False, default="NFSExport1", help="a volume to fetch info about")

    args = parser.parse_args()

    if args.user:
        username = args.user
    else:
        username = "starfish"

    headers = {"Content-Type": "application/json"}

    d = f'{{"username": "{username}", "password": "{args.passwd}"}}'

    urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
    response = requests.post(f"https://{args.server_addr}/api/auth/", data=d, headers=headers, verify=False, timeout=60)
    if response.status_code != 200:
        print("invalid auth response")
        print(response.request)
        print(response.reason)
        print("failed getting bearer token")
        sys.exit(1)

    token = response.json()["token"]
    headers["Authorization"] = "Bearer " + token
    print("auth token is: " + headers["Authorization"])

    print("getting volumes")
    r = requests.get(f"https://{args.server_addr}/api/volume/", headers=headers, verify=False, timeout=60).json()

    # get list of volumes
    if "error" in r:
        print("error in getting volumes via api")
        print(json.dumps(r, indent=4, sort_keys=True))
        sys.exit(0)
    for v in r:
        print(str(v["mounts"]) + " " + str(v["vol"]))

    print(f"get agent for {args.volume} volume")
    sess = requests.Session()
    r = sess.get(f"https://{args.server_addr}/api/volume/{args.volume}/", headers=headers, verify=False).json()
    print(r["default_agent_address"])

    print("----")

    # get list of archive targets
    print("archive targets")
    r = sess.get(f"https://{args.server_addr}/api/archive/target?obfuscate=false", headers=headers, verify=False)
    print(json.dumps(r.json(), indent=4, sort_keys=True))
    # extra to get mounts:
    # for mounts
    # for v in r:
    #     print(str(v['mounts']) + ' ' + (v['vol']))

    print("----")
    print("scan list")
    # scan list
    r = sess.get(f"https://{args.server_addr}/api/scan/?limit=5", headers=headers, verify=False)
    print(json.dumps(r.json(), indent=4, sort_keys=True))

    print("----")
    print("query volume/path children-only")
    # query volume/path
    r = sess.get(
        f"https://{args.server_addr}/api/query/Target:Applications?children-only&type=d", headers=headers, verify=False
    )
    print(json.dumps(r.json(), indent=4, sort_keys=True))

    print("----")
    print("query has-copy")
    # 0 len query
    r = sess.get(
        f"https://{args.server_addr}/api/query/home%3A/?query=has-copy&format=jobs",
        headers=headers,
        verify=False,
    )
    print(json.dumps(r.json(), indent=4, sort_keys=True))
    print("----")

    print("limit query result set to 9 rows")
    r = sess.get(
        f"https://{args.server_addr}/api/query/home%3A/?query=type%3Df&limit=9&format=fn", headers=headers, verify=False
    )

    print(str(len(r.json())) + " rows")
    for row in r.json():
        print(row["vol_path"])

    print("----")
    print("query files named test over all volumes")
    # files named test
    r = sess.get(f"https://{args.server_addr}/api/query/?query=name%3Dtest&limit=10", headers=headers, verify=False)
    for row in r.json():
        print(row["full_path"])

    print("----")
    print("query files named extension png")
    # get files with png extension
    r = sess.get(
        f"https://{args.server_addr}/api/query/Target:/?query=ext%3Dpng&limit=10", headers=headers, verify=False
    )
    for el in r.json():
        print(el["full_path"])

    print("----")
    print("list 2 jobs by jobid")
    # grab job id
    r = sess.get(f"https://{args.server_addr}/api/job/?limit=2", headers=headers, verify=False)
    print(r.json()[0]["long_id"])
    print(r.json()[1]["long_id"])
