#!/bin/bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

_SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
readonly _SCRIPT_DIR
# shellcheck source=scripts/installation/_utils.sh
source "${_SCRIPT_DIR}/_utils.sh"

UPDATE_CACHE=true


file_contains_line_with_prefix() {
    local file_path=$1
    local line=$2

    test -e "${file_path}" && grep --silent "^${line}" "${file_path}"
}

centos_install_starfish_misc_repo() {
    local yum_repo yum_url yum_repo_host_path
    local gpg_old_file=/etc/pki/rpm-gpg/starfish-armored.gpg
    local gpg_new_file=/etc/pki/rpm-gpg/RPM-GPG-KEY-STARFISH

    if  [[ -e "${gpg_old_file}" && ! -e "${gpg_new_file}" ]]; then
        cp "${gpg_old_file}" "${gpg_new_file}"
    fi

    repo_name=starfish-misc-cloudsmith
    yum_repo=/etc/yum.repos.d/starfish-misc.repo
    yum_repo_host_path="repo.starfishstorage.com/starfish_public/starfish_misc_yum/rpm/el/$(centos_get_major_version)/x86_64"
    if [[ "${YUM_CACHE:-""}" != "" ]]; then
        # yum cache configured
        # NOTE: that URL works on Jenkins machines which have configured HTTP cache
        # which is configured to redirect http://repo.starfishstorage.com to https://repo.starfishstorage.com
        yum_url="http://${yum_repo_host_path}"
    else
        # no yum cache
        yum_url="https://${yum_repo_host_path}"
    fi

    if file_contains_line_with_prefix "${yum_repo}" "baseurl.*${yum_repo_host_path}" && \
       file_contains_line_with_prefix "${yum_repo}" gpgcheck.*=.*1 && \
       file_contains_line_with_prefix "${yum_repo}" "gpgkey.*=.*file://${gpg_new_file}"; then
        UPDATE_CACHE=false
        return
    fi

    cat <<_EOF >"${yum_repo}"
[${repo_name}]
name=Packages with open-source software used by Starfish
baseurl=${yum_url}
gpgcheck=1
enabled=1
gpgkey=file://${gpg_new_file}
_EOF
}

ubuntu_install_starfish_misc_repo() {
    local apt_repo apt_host_path ubuntu_distro source_def component

    apt_repo=/etc/apt/sources.list.d/starfish-misc.list
    component=main
    apt_host_path=repo.starfishstorage.com/starfish_public/starfish_misc_apt/deb/ubuntu
    if [[ "${APT_CACHE:-""}" != "" ]]; then
        source_def="deb ${APT_CACHE}/HTTPS///${apt_host_path}"
    else
        source_def="deb https://${apt_host_path}"
    fi

    if file_contains_line_with_prefix "${apt_repo}" "deb.*${apt_host_path}"; then
        echo "Starfish misc repo already added"
        UPDATE_CACHE=false
        return
    fi

    ubuntu_distro=$(map_to_ubuntu_distro)
    echo "${source_def} ${ubuntu_distro} ${component}" > "${apt_repo}"
}

ubuntu_update_cache() {
    apt-get update
    if [[ "${APT_CACHE:-""}" != "" ]]; then
        # workaround for a bug in apt-cache-ng
        # https://bugs.launchpad.net/ubuntu/+source/apt-cacher-ng/+bug/1826405
        # first apt-get update may fail with
        # Err:4 http://sf-aptcache:3142/HTTPS///repo.starfishstorage.com/starfish_public/starfish_misc_apt/deb/ubuntu focal InRelease
        #  503  Inconsistent file state [IP: 192.168.254.136 3142]
        # second apt-get update succeeds
        apt-get update
    fi
}

install_starfish_misc_repo() {
    # Note: do not try to use scripts provided by cloudsmith (setup.deb.sh and/or setup.rpm.sh) to setup repository
    # because these scripts always update repositories while this script is also invoked in _post_install.sh script
    # and updating repositories must be disabled.
    log "Installing Starfish misc repo..."
    run_func_for_distro centos_install_starfish_misc_repo ubuntu_install_starfish_misc_repo

    if [[ "${UPDATE_CACHE}" == "true" ]]; then
        log "Update cache"
        run_func_for_distro centos_makecache ubuntu_update_cache
    fi
    log "Done"
}

main() {
    if is_offline_installation; then
        echo "Offline installation mode active, Starfish misc repo will not be added."
        exit 0
    fi

    while [[ $# -gt 0 ]]; do
        case $1 in
        --no-cache-update)
            UPDATE_CACHE=false
            ;;
        *)
            break
            ;;
        esac
        shift
    done

    install_starfish_misc_repo
}

main "$@"
