/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE OR REPLACE FUNCTION sf_volumes.recreate_views(run_me text, VARIADIC views text[])
  RETURNS void
AS  $$
DECLARE
    view_defs TEXT[];
    schema_names TEXT[];
    i INTEGER;
    def TEXT;
    schema_name TEXT;
BEGIN
    FOR i IN array_lower(views,1) .. array_upper(views,1) loop
        SELECT definition, schemaname INTO def, schema_name
        FROM pg_views
        WHERE viewname = views[i];

        view_defs[i] := def;
        schema_names[i] := schema_name;
        IF def IS NOT NULL THEN
            EXECUTE 'DROP VIEW ' || schema_name || '.' || views[i];
        END IF;
    END loop;

    EXECUTE run_me;

    FOR i IN reverse array_upper(views,1) .. array_lower(views,1) loop
        IF view_defs[i] IS NOT NULL THEN
            def = 'CREATE OR REPLACE VIEW ' || schema_names[i] || '.' || views[i] || ' AS ' || view_defs[i];
            EXECUTE def;
            IF schema_names[i] = 'sf_reports' THEN
                EXECUTE 'GRANT ALL PRIVILEGES ON ALL TABLES IN SCHEMA sf_reports TO pgagent';
            END IF;
        END IF;
    END loop;
END
$$
LANGUAGE plpgsql;

SELECT sf_volumes.recreate_views('ALTER TABLE sf_volumes.volume ALTER COLUMN total_capacity TYPE NUMERIC',
                                 'internal_dir_nonrecursive_size_report_query',
                                 'internal_extensions_report_query',
                                 'internal_file_size_report_query',
                                 'internal_last_time_generic_report_query',
                                 'internal_stats_report_query',
                                 'internal_tags_report_query');

SELECT sf_volumes.recreate_views('ALTER TABLE IF EXISTS sf_reports.stats_history ALTER COLUMN "total capacity" TYPE NUMERIC',
                                 'stats_history_view',
                                 'stats_current'
                                 );
