/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE EXTENSION IF NOT EXISTS plpython3u;

-- REMEMBER THAT THERE IS NO PL/PYTHON ON WINDOWS!

CREATE OR REPLACE FUNCTION sf.posix_path_ancestors(posix_path TEXT, include_self BOOLEAN = True)
  RETURNS TABLE (
    path TEXT
  )
AS $$
    path = posix_path
    posix_path_sep = '/'
    ret = []
    if include_self:
        ret.append(path)
    if path == posix_path_sep:
        path = ''
    path = path.rstrip(posix_path_sep)
    while path:
        idx = path.rfind(posix_path_sep)
        if idx == -1:
            if path:
                ret.append('')
            break
        path = path[: idx] # <== this space between : and idx is important - otherwise it thinks that it is bind param!
        ret.append(path or posix_path_sep)
    for p in ret:
        yield p
$$ LANGUAGE plpython3u SECURITY DEFINER IMMUTABLE PARALLEL SAFE;
