/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

DROP TABLE IF EXISTS sf_internal.event_{{ pipeline_id }};
DROP TABLE IF EXISTS sf_internal.event_loading_{{ pipeline_id }};

CREATE UNLOGGED TABLE sf_internal.event_{{ pipeline_id }} () INHERITS (sf_internal.event_base);
CREATE UNLOGGED TABLE sf_internal.event_loading_{{ pipeline_id }} () INHERITS (sf_internal.event_base);

CREATE INDEX event_dir_depth_idx_{{ pipeline_id }}
    ON sf_internal.event_{{ pipeline_id }} (depth) WHERE type = 16384;
CREATE INDEX event_loading_dir_depth_idx_{{ pipeline_id }}
    ON sf_internal.event_loading_{{ pipeline_id }} (depth) WHERE type = 16384;

-- No need to autovacuum internal tables as they're truncated after processing.
ALTER TABLE sf_internal.event_{{ pipeline_id }} SET (autovacuum_enabled = false, toast.autovacuum_enabled = false);
ALTER TABLE sf_internal.event_loading_{{ pipeline_id }} SET (autovacuum_enabled = false, toast.autovacuum_enabled = false);
ALTER TABLE sf_internal.event_{{ pipeline_id }} ALTER COLUMN seq_num SET(n_distinct = -1);
ALTER TABLE sf_internal.event_loading_{{ pipeline_id }} ALTER COLUMN seq_num SET(n_distinct = -1);
