# ***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
# ***********************************************************************************************************
"""Scan tables"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "0001"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.execute("create schema sf_scans;")
    op.execute("create sequence sf_scans.scan_id_seq start with 1;")
    op.create_table(
        "scan",
        sa.Column(
            "id", sa.BigInteger(), server_default=sa.text("nextval('sf_scans.scan_id_seq'::regclass)"), nullable=False
        ),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("volume_id", sa.BigInteger(), nullable=False),
        sa.Column("type", sa.String(), nullable=False),
        sa.Column("state_name", sa.String(), nullable=False),
        sa.Column("reason", sa.String(), nullable=True),
        sa.Column("reason_msg", sa.String(), nullable=True),
        sa.Column("creation_time", sa.DateTime(timezone=True), nullable=False),
        sa.Column("heartbeat", sa.DateTime(timezone=True), nullable=True),
        sa.Column("agent_address", sa.String(), nullable=True),
        sa.Column("crawler_pid", sa.BigInteger(), nullable=True),
        sa.Column("last_chunk", sa.String(), nullable=True),
        sa.Column("applied_events", sa.BigInteger(), nullable=False),
        sa.Column("loading_priority", sa.Integer(), nullable=False),
        sa.Column("overlapping_check_disabled", sa.Boolean(), nullable=False),
        sa.Column("requested_by", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
        schema="sf_scans",
    )
    op.create_index("scan_creation_time_idx", "scan", ["creation_time"], unique=False, schema="sf_scans")
    op.create_index("scan_state_name_idx", "scan", ["state_name"], unique=False, schema="sf_scans")
    op.create_index("scan_volume_id_idx", "scan", ["volume_id"], unique=False, schema="sf_scans")

    op.create_table(
        "crawler_options",
        sa.Column("scan_id", sa.BigInteger(), nullable=False),
        sa.Column("startpoint", sa.String(), nullable=False),
        sa.Column("ignore_dirs", postgresql.ARRAY(sa.String()), nullable=False),
        sa.Column("ignore_files", postgresql.ARRAY(sa.String()), nullable=False),
        sa.Column("depth", sa.BigInteger(), nullable=True),
        sa.Column("processes_num", sa.BigInteger(), nullable=True),
        sa.Column("mod_log_level", sa.String(), nullable=False),
        sa.Column("samqfs", sa.Boolean(), nullable=False),
        sa.Column("sls_path", sa.String(), nullable=True),
        sa.Column("force_sls", sa.Boolean(), nullable=False),
        sa.Column("posix_acl", sa.Boolean(), nullable=True),
        sa.Column("cifs_acl", sa.Boolean(), nullable=True),
        sa.Column("getcifsacl_path", sa.String(), nullable=True),
        sa.Column("wbinfo_path", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(["scan_id"], ["sf_scans.scan.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("scan_id"),
        schema="sf_scans",
    )
    op.create_table(
        "crawler_info",
        sa.Column("scan_id", sa.BigInteger(), nullable=False),
        sa.Column("stats", postgresql.JSONB(), nullable=False),
        sa.Column("heartbeat", sa.DateTime(timezone=True), nullable=True),
        sa.Column("finished", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(["scan_id"], ["sf_scans.scan.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("scan_id"),
        schema="sf_scans",
    )
    op.create_table(
        "loader_info",
        sa.Column("scan_id", sa.BigInteger(), nullable=False),
        sa.Column("stats", postgresql.JSONB(), nullable=False),
        sa.Column("heartbeat", sa.DateTime(timezone=True), nullable=True),
        sa.Column("last_chunk_process_time", sa.DateTime(timezone=True), nullable=True),
        sa.ForeignKeyConstraint(["scan_id"], ["sf_scans.scan.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("scan_id"),
        schema="sf_scans",
    )


def downgrade():
    op.drop_table("loader_stats", schema="sf_scans")
    op.drop_table("crawler_stats", schema="sf_scans")
    op.drop_table("crawler_options", schema="sf_scans")
    op.drop_table("scan", schema="sf_scans")
    op.execute("drop schema sf_scans;")
