/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */


CREATE OR REPLACE FUNCTION sf_auth.add_missing_zone_restoring_manager_role(
    zone_id BIGINT
    )
RETURNS VOID as
$$
DECLARE
    _role_id BIGINT;
    _ability_id BIGINT;

BEGIN
    INSERT INTO  sf_auth."role" (name)
    VALUES ('zone-' || zone_id || '-restoring-managers')
    RETURNING id INTO _role_id; -- role.id

    FOR _ability_id IN
        INSERT INTO sf_auth.ability (type, "method", value)
        VALUES
            ('zone', 'create-in-zone', zone_id),
            ('zone', 'delete-in-zone', zone_id),
            ('zone', 'read-in-zone', zone_id)
        RETURNING id
    LOOP
        INSERT INTO sf_auth.role_ability (role_id, ability_id)
        VALUES (_role_id, _ability_id);
    END LOOP;
END;
$$ LANGUAGE plpgsql SECURITY DEFINER VOLATILE PARALLEL UNSAFE;


SELECT sf_auth.add_missing_zone_restoring_manager_role(z.id)
FROM sf_auth."zone" z
WHERE NOT EXISTS (
    SELECT 1
    FROM sf_auth."role" r
    WHERE name = 'zone-' || z.id || '-restoring-managers'
);
