#!/bin/bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

enable_repos() {
    local repo_file
    repo_file="$(readlink --canonicalize-missing "$1")"
    shift

    local augeas_cmds_temp_file repo

    augeas_cmds_temp_file="$(mktemp .sf.yum_repo.augeas.XXXXX)"

    cat > "${augeas_cmds_temp_file}" <<EOF
set /augeas/load/Yum/lens Yum.lns
set /augeas/load/Yum/incl ${repo_file}
load
EOF

    for repo in "$@"; do
        if [[ $(grep --count "^\[${repo}\]$" "${repo_file}") -gt 0 ]]; then
            echo "set /files${repo_file}/${repo}/enabled 1" >> "${augeas_cmds_temp_file}"
        fi
    done

    cat >> "${augeas_cmds_temp_file}" <<EOF
save
print /augeas//error
EOF

    augtool --noautoload < "${augeas_cmds_temp_file}"
    rm -f -- "${augeas_cmds_temp_file}"
}

disable_all_repos() {
    local repo_file="$1"

    sed -i 's|enabled=1|enabled=0|' "${repo_file}"
}

dnf_disable_module_if_available() {
    local module modules=( "$@" )

    for module in "${modules[@]}"; do
        # `dnf module list --enabled` lists only modules which have been explicitly enabled with `dnf module enabled`
        # so it doesn't list modules which are available by default
        # we're doing the check and disabling module only if dnf knows about it as some customers may have modified
        # available dnf modules (e.g. by removing default modules)
        if [[ $(dnf --assumeyes module list --available | grep --count --extended-regexp "^${module}\W+" || true) -gt 0 ]]; then
            log "Disabling dnf module ${module}"
            dnf --assumeyes --quiet module disable "${module}"
        fi
    done
}

