#!/bin/bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

INI_FILE_SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
readonly INI_FILE_SCRIPT_DIR

_load_ini_and_print_errors() {
    local file_path="$1"

    augtool --include "${INI_FILE_SCRIPT_DIR}" --noautoload <<EOF
set /augeas/load/IniFile/lens Pgbouncer.lns
set /augeas/load/IniFile/incl ${file_path}
load
ls /augeas/files${file_path}/error/
EOF
}

validate_ini_file() {
    local file_path errors
    file_path="$(readlink --canonicalize-missing "$1")"

    errors=$(_load_ini_and_print_errors "${file_path}")
    if [[ "${errors}" != "" ]]; then
        echo -n "Could not parse ${file_path} as INI file: "
        echo "${errors}" | grep -v "^lens" | tr '\n' ','
        echo
        return 1
    fi
}

set_ini_property() {
    local file_path
    file_path="$(readlink --canonicalize-missing "$1")"
    local section_name="$2"
    local key="$3"
    local value="$4"

    augtool --include "${INI_FILE_SCRIPT_DIR}" --noautoload <<EOF
set /augeas/load/IniFile/lens Pgbouncer.lns
set /augeas/load/IniFile/incl ${file_path}
load
set /files${file_path}/${section_name}/${key} ${value}
save
print /augeas//error
EOF
}

get_ini_property() {
    local file_path
    file_path="$(readlink --canonicalize-missing "$1")"
    local section_name="$2"
    local key="$3"

    # augtool prints something like: /path/etc/01-service.ini/agent/ssl_certificate_file = /etc/sf-agent:localhost.localdomain.crt
    augtool --include "${INI_FILE_SCRIPT_DIR}" --noautoload <<EOF | cut --only-delimited -f 2- -d = | tail -c +2
set /augeas/load/IniFile/lens Pgbouncer.lns
set /augeas/load/IniFile/incl ${file_path}
load
get /files${file_path}/${section_name}/${key}
EOF
}

_rm_ini_part() {
    local file_path
    file_path="$(readlink --canonicalize-missing "$1")"
    local section_or_property="$2"

    augtool --include "${INI_FILE_SCRIPT_DIR}" --noautoload <<EOF
set /augeas/load/IniFile/lens Pgbouncer.lns
set /augeas/load/IniFile/incl ${file_path}
load
rm /files${file_path}/${section_or_property}
save
print /augeas//error
EOF
}

rm_ini_section() {
    _rm_ini_part "$@"
}

rm_ini_property() {
    local file_path="$1"
    local section_name="$2"
    local property_name="$3"

    _rm_ini_part "${file_path}" "${section_name}/${property_name}"
}

mv_ini_properties() {
    local src_file dst_file key
    src_file="$(readlink --canonicalize-missing "$1")"
    dst_file="$(readlink --canonicalize-missing "$2")"
    local section_name="$3"
    shift 3

    temp_file="$(mktemp .sf.augeas.XXXXX)"
    cat > "${temp_file}" <<EOF
set /augeas/load/IniFile/lens Pgbouncer.lns
set /augeas/load/IniFile/incl[1] ${src_file}
set /augeas/load/IniFile/incl[2] ${dst_file}
load
EOF
    for key in "$@"; do
        echo "mv /files${src_file}/${section_name}/${key} /files${dst_file}/${section_name}/${key}" >> "${temp_file}"
    done
    echo "save" >> "${temp_file}"
    echo "print /augeas//error" >> "${temp_file}"
    augtool --include "${INI_FILE_SCRIPT_DIR}" --noautoload < "${temp_file}"
    rm -f -- "${temp_file}"
}
