/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

-- we need to add _part_XYZ suffix here because CREATE OR REPLACE works only when PSQL function is created sequentially
-- and here it is possible to execute this code concurrently
CREATE OR REPLACE FUNCTION __get_tablespace_part_{{ partition_id }}(full_tablename VARCHAR)
RETURNS VARCHAR AS  -- returns NULL if the table is in default tablespace or it does not exist
$$
DECLARE
    result VARCHAR;
BEGIN
    SELECT tablespace
      INTO result
      FROM pg_tables
     WHERE (schemaname || '.' || tablename) = full_tablename;

    RETURN result;
END;
$$ LANGUAGE plpgsql STRICT IMMUTABLE PARALLEL SAFE;

-- we need to add _part_XYZ suffix here because CREATE OR REPLACE works only when PSQL function is created sequentially
-- and here it is possible to execute this code concurrently
CREATE OR REPLACE FUNCTION __move_to_same_custom_tablespace_part_{{ partition_id }}(table_to_move VARCHAR, reference_table VARCHAR)
RETURNS VOID AS
$$
DECLARE
    tblspc VARCHAR;
BEGIN
    SELECT __get_tablespace_part_{{ partition_id }}(reference_table) INTO tblspc;
    IF tblspc IS NOT NULL THEN
        EXECUTE 'ALTER TABLE ' || table_to_move || ' SET TABLESPACE ' || quote_ident(tblspc);
    END IF;
END;
$$ LANGUAGE plpgsql STRICT VOLATILE PARALLEL UNSAFE;


-- Don't be tempted to change CREATE TABLE, ALTER TABLE to a single statement like this:
--   CREATE TABLE sf.dir_current_part_{{ partition_id }} PARTITION OF sf.dir_current FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});
-- because it requires AccessExclusive lock on sf.dir_current.
-- The following statements do the same with much weaker ShareUpdateExclusive lock.

CREATE TABLE sf.dir_current_part_{{ partition_id }} (LIKE sf.dir_current INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.dir_current_part_{{ partition_id }}', 'sf.dir_current');
ALTER TABLE sf.dir_current ATTACH PARTITION sf.dir_current_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});
CREATE TABLE sf.dir_history_part_{{ partition_id }} (LIKE sf.dir_history INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.dir_history_part_{{ partition_id }}', 'sf.dir_history');
ALTER TABLE sf.dir_history ATTACH PARTITION sf.dir_history_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});

CREATE TABLE sf.file_current_part_{{ partition_id }} (LIKE sf.file_current INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.file_current_part_{{ partition_id }}', 'sf.file_current');
ALTER TABLE sf.file_current ATTACH PARTITION sf.file_current_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});
CREATE TABLE sf.file_history_part_{{ partition_id }} (LIKE sf.file_history INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.file_history_part_{{ partition_id }}', 'sf.file_history');
ALTER TABLE sf.file_history ATTACH PARTITION sf.file_history_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});

CREATE TABLE sf.job_result_current_part_{{ partition_id }} (LIKE sf.job_result_current INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.job_result_current_part_{{ partition_id }}', 'sf.job_result_current');
ALTER TABLE sf.job_result_current ATTACH PARTITION sf.job_result_current_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});
CREATE TABLE sf.job_result_history_part_{{ partition_id }} (LIKE sf.job_result_history INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.job_result_history_part_{{ partition_id }}', 'sf.job_result_history');
ALTER TABLE sf.job_result_history ATTACH PARTITION sf.job_result_history_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});

CREATE TABLE sf.tag_value_current_part_{{ partition_id }} (LIKE sf.tag_value_current INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.tag_value_current_part_{{ partition_id }}', 'sf.tag_value_current');
ALTER TABLE sf.tag_value_current ATTACH PARTITION sf.tag_value_current_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});
CREATE TABLE sf.tag_value_history_part_{{ partition_id }} (LIKE sf.tag_value_history INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.tag_value_history_part_{{ partition_id }}', 'sf.tag_value_history');
ALTER TABLE sf.tag_value_history ATTACH PARTITION sf.tag_value_history_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});

CREATE TABLE sf.custom_fs_attrs_current_part_{{ partition_id }} (LIKE sf.custom_fs_attrs_current INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.custom_fs_attrs_current_part_{{ partition_id }}', 'sf.custom_fs_attrs_current');
ALTER TABLE sf.custom_fs_attrs_current ATTACH PARTITION sf.custom_fs_attrs_current_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});
CREATE TABLE sf.custom_fs_attrs_history_part_{{ partition_id }} (LIKE sf.custom_fs_attrs_history INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.custom_fs_attrs_history_part_{{ partition_id }}', 'sf.custom_fs_attrs_history');
ALTER TABLE sf.custom_fs_attrs_history ATTACH PARTITION sf.custom_fs_attrs_history_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});

CREATE TABLE sf.refresh_aggregates_part_{{ partition_id }} (LIKE sf.refresh_aggregates INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.refresh_aggregates_part_{{ partition_id }}', 'sf.refresh_aggregates');
ALTER TABLE sf.refresh_aggregates ATTACH PARTITION sf.refresh_aggregates_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});

CREATE TABLE sf.dir_metadata_part_{{ partition_id }} (LIKE sf.dir_metadata INCLUDING ALL);
ALTER TABLE sf.dir_metadata_part_{{ partition_id }} ADD CONSTRAINT dir_metadata_volume_id_fk FOREIGN KEY (volume_id, dir_id) REFERENCES sf.dir_current_part_{{ partition_id }}(volume_id, id) ON DELETE CASCADE;
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.dir_metadata_part_{{ partition_id }}', 'sf.dir_metadata');
ALTER TABLE sf.dir_metadata ATTACH PARTITION sf.dir_metadata_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});


CREATE TABLE sf.calculated_aggrs_part_{{ partition_id }} (LIKE sf.calculated_aggrs INCLUDING ALL);
SELECT __move_to_same_custom_tablespace_part_{{ partition_id }}('sf.calculated_aggrs_part_{{ partition_id }}', 'sf.calculated_aggrs');
ALTER TABLE sf.calculated_aggrs ATTACH PARTITION sf.calculated_aggrs_part_{{ partition_id }} FOR VALUES WITH (modulus {{max_number_of_partitions}}, remainder {{ partition_id }});
-- intentionally not migrating autovacuum_analyze_threshold=1000000000 to enable autovacuum on this table,
-- as we do not truncate it anymore

ALTER TABLE sf.dir_current_part_{{ partition_id }} SET (
            autovacuum_vacuum_threshold = 10000,
            autovacuum_vacuum_scale_factor = 0.025,
            autovacuum_analyze_threshold = 50,
            autovacuum_analyze_scale_factor = 0.01
);

ALTER TABLE sf.dir_history_part_{{ partition_id }} SET (
            autovacuum_vacuum_threshold = 10000,
            autovacuum_vacuum_scale_factor = 0.025,
            autovacuum_analyze_threshold = 50,
            autovacuum_analyze_scale_factor = 0.01
);

ALTER TABLE sf.file_current_part_{{ partition_id }} SET (
            autovacuum_vacuum_threshold = 10000,
            autovacuum_vacuum_scale_factor = 0.025,
            autovacuum_analyze_threshold = 50,
            autovacuum_analyze_scale_factor = 0.01
);

ALTER TABLE sf.file_history_part_{{ partition_id }} SET (
            autovacuum_vacuum_threshold = 10000,
            autovacuum_vacuum_scale_factor = 0.025,
            autovacuum_analyze_threshold = 50,
            autovacuum_analyze_scale_factor = 0.01
);

ALTER TABLE sf.job_result_current_part_{{ partition_id }} SET (
    autovacuum_vacuum_threshold = 10000,
    autovacuum_vacuum_scale_factor = 0.025,
    autovacuum_analyze_threshold = 50,
    autovacuum_analyze_scale_factor = 0.01
);

ALTER TABLE sf.job_result_history_part_{{ partition_id }} SET (
    autovacuum_vacuum_threshold = 10000,
    autovacuum_vacuum_scale_factor = 0.025,
    autovacuum_analyze_threshold = 50,
    autovacuum_analyze_scale_factor = 0.01
);

ALTER TABLE sf.tag_value_current_part_{{ partition_id }} SET (
    autovacuum_vacuum_threshold = 10000,
    autovacuum_vacuum_scale_factor = 0.025,
    autovacuum_analyze_threshold = 50,
    autovacuum_analyze_scale_factor = 0.01
);

ALTER TABLE sf.tag_value_history_part_{{ partition_id }} SET (
    autovacuum_vacuum_threshold = 10000,
    autovacuum_vacuum_scale_factor = 0.025,
    autovacuum_analyze_threshold = 50,
    autovacuum_analyze_scale_factor = 0.01
);

ALTER TABLE sf.file_current_part_{{ partition_id }} ALTER COLUMN parent_id SET (n_distinct=-0.002);
ALTER TABLE sf.file_history_part_{{ partition_id }} ALTER COLUMN parent_id SET (n_distinct=-0.002);
ALTER TABLE sf.dir_current_part_{{ partition_id }} ALTER COLUMN parent_id SET (n_distinct=-0.1);
ALTER TABLE sf.dir_history_part_{{ partition_id }} ALTER COLUMN parent_id SET (n_distinct=-0.1);

ALTER TABLE sf.dir_current_part_{{partition_id}} ALTER COLUMN ancestor_ids SET statistics 10000;
