#!/bin/bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

SFHOME="${SFHOME:-/opt/starfish}"

# shellcheck source=scripts/installation/_install_params.sh
source "${SFHOME}/data/installation/_install_params.sh"

# _ini_file.sh uses INI lens which makes all the sections in INI file
# elements of the tree, e.g.
# ```
# [section]
# setting=value
# ```
# will become
# `/augeas/files/opt/starfish/etc/file.ini/section/setting = value`
# this makes `/` a forbidden char in the section name

# to avoid just checking for `/` in the section names (there may be other gotchas)
# augeas is asked to load all the `*.ini` files and report errors

to_check=()
for ini_file in "${STARFISH_ETC_DIR}"/*.ini; do
    # exclude 98-reports.ini - it contains names of reports from Redash as keys
    # they may contain spaces which isn't parseable by augeas
    # it's not a problem, however, as this file is not read or updated by augeas
    # and because it's automatically generated there should be no reason to process it with augeas
    if [[ "$(basename "${ini_file}")" != 98-reports.ini ]]; then
        to_check+=("${ini_file}")
    fi
done

# `validate_ini_files.sh` will fail if any of the files cannot be loaded by augeas
"${SFHOME}/data/installation/validate_ini_files.sh" "${to_check[@]}"
