/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- tag_drilldown_redash_query.sql
 -- zone_drilldown_redash_query.sql
 -- tag_in_zone_drilldown_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT '<a href="DASHBOARD_LINK(zone-tag-detail-analytics)?p_zone='||urlencode(zone)||'&p_tagset='||urlencode(namespace)||'&p_tag='||urlencode(tag)||'">'||urlencode(zone)||'/'||urlencode(namespace)||':'||urlencode(tag)||'</a>' AS "zone/tag",
       SUM(size) / (1024 * 1024 * 1024.0) AS "logical size (GiB)",
       SUM(physical_size) / (1024 * 1024 * 1024.0) AS "physical size (GiB)",
       SUM(count)::BIGINT AS "count",
       MAX(run_time)::TIMESTAMP AS "update time"  -- we cast it to timestamp to cut off timezone info
       -- otherwise redash is showing invalid time (looks like bug in redash)
FROM sf_reports.zone_namespace_tags_current AS zt
GROUP BY zt.zone, zt.namespace, zt.tag
ORDER BY zt.zone, zt.namespace, zt.tag;
