/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    run_time::DATE AS date,
    "max depth" AS max_depth,
    ROUND("avg depth", 2) AS avg_depth
FROM sf_reports.stats_history
WHERE "volume name" = '{{volume}}'
  AND ({{number_of_days_to_look_back}} = -1 OR
       run_time >= (NOW() - INTERVAL '{{number_of_days_to_look_back}} day')::DATE)
ORDER BY date ASC
