/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH first_record AS (
    SELECT min(run_time) AS run_time
    FROM sf_reports.stats_history
    WHERE "volume name" = '{{volume}}'
), diff_report AS (
	SELECT
	    stats_history."volume name" AS volume,
		COALESCE(
		    "volume occupied space" - lag("volume occupied space")
		        OVER (PARTITION BY "volume name" ORDER BY stats_history.run_time),
		    "total file size" - lag("total file size")
		        OVER (PARTITION BY "volume name" ORDER BY stats_history.run_time),
		    CASE WHEN stats_history.run_time = first_record.run_time
		        THEN COALESCE("volume occupied space", "total file size")
		        ELSE 0
		    END) AS size_diff,
		COALESCE(
		    "regular files" - lag("regular files")
		        OVER (PARTITION BY "volume name" ORDER BY stats_history.run_time),
		    CASE WHEN stats_history.run_time = first_record.run_time
		        THEN "regular files"
		        ELSE 0
		    END) AS file_count_diff,
		-- line below is: convert to epoch (seconds since 1970), round to X days, convert back to date
		to_timestamp(
		    ROUND(
		        EXTRACT(EPOCH FROM stats_history.run_time) / (3600 * 24 * {{group_by_days}})
		    ) * (3600 * 24 * {{group_by_days}})
		)::DATE AS date
	FROM sf_reports.stats_history
	    CROSS JOIN first_record
	WHERE stats_history.run_time >= now() - INTERVAL '{{number_of_days_to_look_back}} days'
    AND "volume name" = '{{volume}}'
) SELECT volume,
	 ROUND(SUM(size_diff) / (1024 * 1024 * 1024.0), 2) AS size_diff_gib,
	 SUM(file_count_diff) AS file_count_diff,
	 date
FROM diff_report
GROUP BY volume, date
ORDER BY volume, date DESC
