/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT COALESCE(volume.display_name, last_time_generic_history.volume_name) AS "volume",
       user_name AS "username",
       ROUND(SUM(size)/(1024*1024*1024.0), 2) AS "logical size (GiB)",
       ROUND(SUM(COALESCE(physical_size, size))/(1024*1024*1024.0), 2) AS "physical size (GiB)",
       SUM(count) AS count,
       SUM(cost) AS cost,
       run_time
FROM sf_reports.last_time_generic_history
    LEFT JOIN sf_volumes.volume ON last_time_generic_history.volume_name = volume.name
WHERE user_name = '{{username}}'
GROUP BY user_name,
         volume,
         run_time
