/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT vol_param.value AS TIER,
       count(*) AS "Number of Volumes",
       ROUND(SUM("total capacity") / (1024 * 1024 * 1024.0), 2)/(count(*)) AS "Average capacity (GiB)",
       ROUND(SUM("total capacity") / (1024 * 1024 * 1024.0), 2) AS "capacity (GiB)",
       ROUND(SUM("volume occupied space") / (1024 * 1024 * 1024.0), 2) AS "used physical (GiB)",
       ROUND(SUM("total file size") / (1024 * 1024 * 1024.0), 2) AS "used logical (GiB)",
       ROUND(SUM("volume free space") / (1024 * 1024 * 1024.0), 2) AS "free (GiB)",
       ROUND(SUM("volume occupied space") * 100 / SUM("total capacity"), 1) as "used %",
       SUM("regular files") AS "regular files",
       SUM("symbolic links") AS "symbolic links",
       ROUND(MAX("maximum file size") / (1024 * 1024 * 1024.0), 2) AS "max file size (GiB)",
       SUM("directories") AS "directories",
       SUM("directories without files") AS "directories with only subdirectories",
       ROUND(SUM("maximum directory non-recursive size") / (1024 * 1024 * 1024.0), 2) AS "max dir size (GiB)"
FROM sf_reports.stats_current stats,
     sf_volumes.volume vol,
     sf_volumes.user_param vol_param
WHERE stats."volume name" = vol.name
  AND vol.id = vol_param.volume_id
  AND vol_param.name = 'tier'
GROUP BY vol_param.value
