/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT vol_param.value AS TIER,
       ROUND(SUM(stats."volume occupied space") / (1024 * 1024 * 1024.0), 2) AS physical_size_gib,
       SUM(stats."regular files") AS files_count,
       run_time
FROM sf_reports.stats_history stats,
     sf_volumes.volume vol,
     sf_volumes.user_param vol_param
WHERE stats."volume name" = vol.name
  AND vol.id = vol_param.volume_id
  AND vol_param.name = 'tier'
GROUP BY vol_param.value, run_time
