/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- tags_in_zone_redash_query.sql
 -- zone_tags_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT
    COALESCE(volume.display_name, tags_current.volume_name) AS volume_name,
    tag,
    atime_age,
    mtime_age,
    ROUND(size / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
    ROUND(physical_size / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
    count,
    cost
FROM sf_reports.tags_current
    LEFT JOIN sf_volumes.volume ON tags_current.volume_name = sf_volumes.volume.name
    WHERE SUBSTRING(tag, 1, length('__')) != '__'
