/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- zone_details_drilldown_redash_query.sql
 -- zone_tag_details_drilldown_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT '<a href="queries/QUERY_ID_FOR_REPORT(top_directories_with_tag)?p_tag='||tag||'">' ||tag|| '</a>' AS tag,
       COALESCE(volume.display_name, tags_current.volume_name) AS volume,
       SUM(size) / (1024 * 1024 * 1024.0) AS "logical size (GiB)",
       SUM(physical_size) / (1024 * 1024 * 1024.0) AS "physical size (GiB)",
       SUM(count)::BIGINT AS "count",
       TRUNC(SUM(cost)::NUMERIC, 2) AS "cost",
       MAX(run_time) AS "update time"
FROM sf_reports.tags_current
    LEFT JOIN sf_volumes.volume ON tags_current.volume_name = volume.name
WHERE tag = '{{{tag}}}'
GROUP BY tag, volume
ORDER BY tag, volume
