/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH max_depth AS (
    SELECT
    volume_id,
    MAX(depth) AS maxdepth
    FROM sf.dir_current d
    GROUP BY volume_id
)

SELECT
    v.name AS "Volume",
    maxdepth AS "Max Depth",
    COUNT(*) AS "Number of Deep Directories"
FROM sf.dir_current d
JOIN max_depth m ON m.volume_id = d.volume_id
JOIN sf_volumes.volume v ON v.id = d.volume_id
WHERE depth > (maxdepth * {{Max_depth_threshold_percentage}}/100)
    AND depth > {{Depth_greater_than}}
    AND {{Max_depth_threshold_percentage}} BETWEEN 0 AND 99
GROUP BY v.name, maxdepth
ORDER BY maxdepth DESC
LIMIT 20
