/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    volume.name AS volume,
    scan.type AS "scan type",
    MAX(scan.creation_time) AS "last start time",
    MAX(scan.heartbeat) AS "last scan response time"
FROM sf_scans.scan scan
INNER JOIN sf_volumes.volume volume ON volume.id = scan.volume_id
WHERE scan.state_name = 'done'
GROUP BY scan.volume_id, volume.name, scan.type
ORDER BY volume, "scan type"
