/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH volumes AS (
    SELECT
        SUM(COALESCE(rec_aggrs->>'blocks_div_nlinks', rec_aggrs->>'blocks')::BIGINT) FILTER(WHERE path='') * 512 AS recursive_physical_size_without_hardlinks,
        SUM(COALESCE(rec_aggrs->>'size_div_nlinks', rec_aggrs->>'size')::NUMERIC) FILTER(WHERE path='') AS recursive_size_without_hardlinks
    FROM sf.dir_current
    WHERE depth = 0
)
SELECT
    'Physical size without hardlinks' as category,
    (SELECT ROUND(recursive_physical_size_without_hardlinks / (1024::BIGINT * 1024*1024),2) FROM volumes) AS "total capacity (GiB)",
    (SELECT recursive_physical_size_without_hardlinks FROM volumes) AS "size (B)"
UNION
SELECT
    'Logical size without hardlinks' as category,
    (SELECT ROUND(recursive_size_without_hardlinks / (1024::BIGINT * 1024*1024),2) FROM volumes) AS "total capacity (GiB)",
    (SELECT recursive_size_without_hardlinks FROM volumes) AS "size (B)"
;
