/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH agents AS (
    SELECT
        default_agent_address AS agent,
        COUNT(*) AS number_of_volumes,
        (SELECT COUNT(*) FROM sf_volumes.volume WHERE vol.default_agent_address = default_agent_address
         AND type ILIKE 'linux') AS linux_volumes,
        (SELECT COUNT(*) FROM sf_volumes.volume WHERE vol.default_agent_address = default_agent_address
         AND type ILIKE 'windows') AS windows_volumes
    FROM sf_volumes.volume vol
    GROUP BY default_agent_address
    ORDER BY default_agent_address
)

SELECT
    agent,
    number_of_volumes AS number_of_volumes,
    linux_volumes AS linux_volumes,
    windows_volumes AS windows_volumes
FROM agents
UNION ALL
SELECT
    'IN TOTAL: ' || COUNT(*),
    SUM(number_of_volumes)::INT,
    SUM(linux_volumes)::INT,
    SUM(windows_volumes)::INT
FROM agents
HAVING COUNT(*) > 0
