/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE OR REPLACE FUNCTION get_parameters_for_redash_scan_alert()
RETURNS TABLE(scans_back INT, heartbeat_interval TEXT, volume_interval TEXT, hb_interval INTERVAL, v_interval INTERVAL)
AS $Body$
    SELECT {{scans_back}}, '{{heartbeat_interval}}', '{{volume_interval}}', INTERVAL '{{heartbeat_interval}}', INTERVAL '{{volume_interval}}';
$Body$
LANGUAGE sql;

SELECT
    scans_back AS "Scan failure threshold",
    heartbeat_interval AS "Maximum monitor idle time",
    volume_interval AS "Last successful scan"
FROM get_parameters_for_redash_scan_alert();
