/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE OR REPLACE FUNCTION check_if_str_is_date(str VARCHAR) RETURNS BOOLEAN AS $$
BEGIN
 IF str IS NULL then
    RETURN FALSE;
 END IF;
 PERFORM str::DATE;
 RETURN TRUE;
 EXCEPTION WHEN OTHERS THEN
    RETURN FALSE;
END;
$$ LANGUAGE PLPGSQL IMMUTABLE PARALLEL UNSAFE;

WITH extensions AS (
  SELECT DISTINCT ext,
                  CASE
                      WHEN ext ~ '^[-_]' THEN ext
                      ELSE REGEXP_REPLACE(ext, CONCAT('^', '{{extension}}', '[-_]'), '')
                  END AS uniq_part
  FROM sf_reports.extensions_current
  WHERE volume_name LIKE '{{volume}}'
    AND ext ~ '^{{extension}}'
),
subext_types AS (
  SELECT ext,
         uniq_part,
         CASE
             WHEN uniq_part = '' THEN 'EMPTY'
             WHEN EXISTS
                    (SELECT REGEXP_MATCHES(uniq_part, '^2[0-9]{3}$')) THEN 'YEAR'
             WHEN EXISTS
                    (SELECT REGEXP_MATCHES(uniq_part, '^2[0-9]{3}[-_](0[1-9]|1[0-2])$')) THEN 'YEAR-MONTH'
             WHEN check_if_str_is_date(uniq_part) THEN 'DATE'
             WHEN EXISTS
                    (SELECT REGEXP_MATCHES(uniq_part, '^[0-9]+$')) THEN 'NUMERIC'
             ELSE 'TEXT'
         END AS "ext_type"
  FROM extensions
  WHERE ext ~ '^{{extension}}[-_]'
)

SELECT '{{extension}}' AS ext,
       (SELECT COUNT(*) FROM subext_types WHERE ext_type='DATE') AS "DATE sub exts",
       (SELECT COUNT(*) FROM subext_types WHERE ext_type='YEAR') AS "YEAR sub exts",
       (SELECT COUNT(*) FROM subext_types WHERE ext_type='YEAR-MONTH') AS "YEAR-MONTH sub exts",
       (SELECT COUNT(*) FROM subext_types WHERE ext_type='NUMERIC') AS "NUMERIC sub exts",
       (SELECT COUNT(*) FROM subext_types WHERE ext_type='TEXT') AS "TEXT sub exts",
       (SELECT COUNT(*) FROM subext_types WHERE ext_type='EMPTY') AS "EMPTY sub exts"
WHERE (SELECT COUNT(*) FROM extensions) > 0
