/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH last_successfull_or_perpetual_scan_per_volume AS (
    SELECT
        DISTINCT ON (volume_id) *
    FROM
        sf_scans.scan
    WHERE
        (state_name='done') OR (type in ('monitor', 'monitor_out_of_sync') AND state_name NOT IN ('monitor_event_monitor_failed', 'monitor_event_monitor_failed_pausing'))
    ORDER BY
        volume_id, heartbeat DESC
),
     time_since_last_heartbeat AS (
         SELECT
             *,
             (EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) - EXTRACT(EPOCH FROM heartbeat)) / 86400 AS days_since_heartbeat
         FROM
             last_successfull_or_perpetual_scan_per_volume
     )
SELECT
    vol.id AS volume_id,
    vol.name AS volume_name,
    tim.reason,
    tim.reason_msg,
    tim.heartbeat,
    ROUND(CAST(tim.days_since_heartbeat as numeric), 2) AS days_since_heartbeat
FROM
    time_since_last_heartbeat tim JOIN sf_volumes.volume vol ON (tim.volume_id=vol.id)
UNION ALL
SELECT NULL AS volume_id,
       NULL AS volume_name,
       NULL AS reason,
       NULL AS reason_msg,
       NULL AS heartbeat,
       0 AS days_since_heartbeat
WHERE NOT EXISTS (SELECT 1 FROM time_since_last_heartbeat)
ORDER BY days_since_heartbeat DESC;
