/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH top_tables AS (
    SELECT
        parent_table
    FROM sf_reports.postgres_table_size_current
    WHERE namespace = 'sf'
    GROUP BY run_time, parent_table
    ORDER BY SUM(total_relation_size) DESC, parent_table
    LIMIT 20
) SELECT
    pt.parent_table AS "table",
    ROUND(SUM(total_relation_size) / 1024.0 / 1024 / 1024, 2) AS "Size (GiB)",
    run_time
FROM sf_reports.postgres_table_size_history pt
JOIN top_tables ON pt.parent_table = top_tables.parent_table
WHERE run_time > NOW() - INTERVAL '730 days'
GROUP BY run_time, pt.parent_table
ORDER BY run_time, SUM(total_relation_size) DESC, pt.parent_table
