/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT pgdb.datname AS "database",
       PG_DATABASE_SIZE(pgdb.datname) AS size,
       tablespace.spcname AS "tablespace",
       pguser.usename AS owner,
       pgdb.datcollate AS "collation"
FROM pg_database pgdb
LEFT JOIN pg_tablespace tablespace ON tablespace.oid = pgdb.dattablespace
LEFT JOIN pg_user pguser ON pguser.usesysid = pgdb.datdba
WHERE pgdb.datname NOT IN ('template0', 'template1')
ORDER BY PG_DATABASE_SIZE(pgdb.datname) DESC, pgdb.datname
