/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH files AS (
    SELECT
        file.volume_id,
        dir.path AS dir_path,
        file.name AS file_name,
        file.size,
        mount.path AS mount_path
    FROM sf.file_current file
    INNER JOIN sf_volumes.volume volume ON volume.id = file.volume_id
    LEFT JOIN sf_volumes.mount mount ON mount.volume_id = file.volume_id AND mount.agent = volume.default_agent_address
    INNER JOIN sf.dir_current dir ON dir.id = file.parent_id
    WHERE '{{volume}}' = '*' OR file.volume_id = (SELECT id FROM sf_volumes.volume WHERE name = '{{volume}}')
    ORDER BY size DESC
    LIMIT {{number_of_rows}}
)

SELECT
    get_full_sys_path(mount_path, dir_path, file_name) AS path,
    ROUND(size / (1024.0 * 1024 * 1024), 2) AS size_GiB
FROM files
ORDER BY size DESC, path ASC
