/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH group_sizes AS (
    SELECT gid, SUM(size) AS group_size
    FROM sf_reports.last_time_generic_current
    GROUP BY gid
), query AS (
    SELECT
        COALESCE(vol.display_name, ltgc.volume_name) AS volume,
        group_name AS group,
        ltgc.gid,
        atime_age AS atime,
        mtime_age AS mtime,
        ROUND(size / (1024 * 1024 * 1024.0), 2) AS "size logical (GiB)",
        ROUND(physical_size / (1024 * 1024 * 1024.0), 2) AS "size physical (GiB)",
        count,
        cost
    FROM sf_reports.last_time_generic_current ltgc
        LEFT JOIN sf_volumes.volume vol ON ltgc.volume_name = vol.name
        LEFT JOIN group_sizes gs ON gs.gid = ltgc.gid
    WHERE gs.group_size >= {{min_size_per_group_GB}}::BIGINT * 1024 * 1024 * 1024
        AND (ROUND(size / (1024 * 1024 * 1024.0), 2) > 0)
)

SELECT * FROM query
UNION ALL
SELECT
    'No results. Decrease Min size per group (GiB) and refresh the report' AS volume,
    NULL AS group,
    NULL AS gid,
    NULL AS atime,
    NULL AS mtime,
    NULL AS "size logical (GiB)",
    NULL AS "size physical (GiB)",
    NULL AS count,
    NULL AS cost
WHERE NOT EXISTS (SELECT 1 FROM query LIMIT 1)
ORDER BY volume, "group", atime DESC, mtime DESC, "size logical (GiB)" DESC, "size physical (GiB)" DESC
