/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT COALESCE(volume.display_name, last_time_generic_history.volume_name) AS "volume",
       group_name AS "groupname",
       ROUND(SUM(COALESCE(physical_size, size))/(1024*1024*1024.0), 2) AS "physical size (GiB)",
       run_time
FROM sf_reports.last_time_generic_history
    LEFT JOIN sf_volumes.volume ON last_time_generic_history.volume_name = volume.name
WHERE group_name = '{{groupname}}'
GROUP BY group_name,
         volume,
         run_time
